%definizione dati e variabili 
out=zeros(145,1); %tempo di rilascio di ciascun job

zeta=0;
W=zeros(10000,10); %Matrice lavoratori inizializzata a 0 perché tutti disponibili in principio. Segna per ogni stato l'occupazione (1) o meno (0) dei lavoratori; il decimo è il saldatore.
Wt=zeros(10000,10); %Matrice correlata alla prima, indica con quale task il lavoratore è occupato
Wp=zeros(10000,10);   %Matrice ‘workers positions’: tiene traccia degli spostamenti dei lavoratori; per ogni stato indica la posizione dei lavoratori. Inizialmente si trovano tutti nella posizione del dispatcher (14); (il saldatore non è inserito perché sta fisso alla stazione 5 (6 per i calcoli).
Wp(1,1:9)=14;
Wp(1,10)=6;
nopdisp=zeros(5000,1);
nteo=zeros(5000,1);
enne=zeros(5000,1);
KK=zeros(5000,1);
neo=zeros(10000,1); %"not enough operators" è 1 quando un task che richiede due operatori sarebbe stato da assegnare ma non si sono trovati abbastanza operatori
incorso=cell(10000,1); %per ogni stato, quali job sono in corso
produzione=0; %segna i job completati
perc=0; %segna quale dei due percorsi per arrivare al consolidamento e assemblaggio viene scelto (1: 31-21-29 , 2:30-20-28)
percw=0; %segna,per il wip, quale dei due percorsi per arrivare al consolidamento e assemblaggio viene scelto (1: 31-21-29 , 2:30-20-28)
percw2=0; %segna,per il secondo wip, quale dei due percorsi per arrivare al consolidamento e assemblaggio viene scelto (1: 31-21-29 , 2:30-20-28)
percw3=0; %segna,per il terzo wip, quale dei due percorsi per arrivare al consolidamento e assemblaggio viene scelto (1: 31-21-29 , 2:30-20-28)
percw4=0; %segna,per il quarto wip, quale dei due percorsi per arrivare al consolidamento e assemblaggio viene scelto (1: 31-21-29 , 2:30-20-28)
finisce=zeros(10000,4); %segna i task che finiscono in ciascuno stato
St=zeros(10000,13); %per segnare quando le stazioni sono già occupate 
Stt=zeros(10000,13);
pass=0;
w11=0; %se 1 dice che c'è già il materiale in attesa del resto per essere processati sulla St10
w12=0; %se 1 dice che c'è già il materiale in attesa del resto per essere processati sulla St11
dist=[0 15.42 24.41823 18.34433 22.15121 7.867757 25.28339 19.83053 14.36672 17.06928 36.45888 37.74416 22.43 9.384716; 15.42 0 37.27125 9.890046 15.9802 19.41077 39.82896 31.1491 23.16676 18.54985 50.8404 49.62513 37.85 22.95487; 24.41823 37.27125 0 34.09684 33.34405 17.94357 7.81025 7 15.19877 24.00563 15.0333 16.02176 17.08435 25.92977; 18.3443 9.890046 34.09684 0 6.090993 18.11374 38.45484 27.26343 18.91317 11.24236 48.77371 48.45991 39.1498 27.5603066; 22.1512076 15.9802 33.34405 6.090993 0 19.77008 38.72965 26.34513 18.44127 9.34 48.34238 48.60934 41.01138 31.5358922; 7.86775699 19.41077 17.94357 18.11374 19.77008 0 20.72418 12.40853 6.608941 12.03497 31.5419 30.69003 21.28043 14.7676843; 25.2833938 39.82896 7.81025 38.45484 38.72965 20.72418 0 13.41641 20.31262 29.51322 11.18034 10.00684 10.51546 23.8569256; 19.830532 31.1491 7 27.26343 26.34513 12.40853 13.41641 0 8.36675 17.00795 22.02272 22.70896 20.07224 23.6776878; 14.366715 23.16676 15.19877 18.91317 18.44127 6.608941 20.31262 8.36675 0 9.204613 30.03502 30.16807 23.97764 21.0957436; 17.0692824 18.54985 24.00563 11.24236 9.34 12.03497 29.51322 17.00795 9.204613 0 39.00295 39.33335 32.61327 25.9500154; 36.4588809 50.8404 15.0333 48.77371 48.34238 31.5419 11.18034 22.02272 30.03502 39.00295 0 4.63 18.76099 31.8065213; 34.7441635 49.62513 16.02176 48.45991 48.60934 30.69003 10.00684 22.70896 30.16807 39.33335 4.63 0 15.16185 31.8065213; 22.43 37.85 17.08435 39.1497957 41.01138 21.28043 10.51546 20.07224 23.97764 32.61327 18.76099 18.76099 0 17.2826676; 9.3847163 22.95487 25.92977 27.5603066 31.53589 14.76768 23.85693 23.67769 21.09574 25.95002 31.80652 31.80652 17.28267 0];   %matrice delle distanze: fissa, i suoi valori non cambieraneo durante il ciclo;
task=[2 16 0 0 0 17 18 1 3 0 36 40 44;2 17 0 0 0 19 0 0 4 0 586.8 652 717.2; 2 19 0 0 0 21 20 2 5 0 561.6 624 686.4;1 22 0 0 0 23 0 0 7 0 314.1 349 383.9;1 23 0 0 0 24 0 0 8 0 453.6 504 554.4;1 24 0 0 0 25 0 0 9 0 923.4 1026 1128.6;1 26 0 0 0 27 0 0 10 0 14.4 16 17.6;3 9 0 0 0 31 30 2 6 0 172.8 192 211.2;3 27 0 0 0 8 0 0 6 0 273.6 304 334.4;3 25 0 0 0 11 0 0 6 0 374.4 416 457.6;3 18 10 0 1 29 28 2 6 0 108 120 132;2 30 20 28 1 14 0 0 11 0 1068.3 1187 1305.7;2 31 21 29 1 15 0 0 12 0 1068.3 1187 1305.7;2 12 0 0 0 32 0 0 11 0 1090.8 1212 1333.2;2 13 0 0 0 33 0 0 12 0 1090.8 1212 1333.2;1 0 0 0 0 1 0 0 2 3 18 20 22;2 1 0 0 0 2 0 0 3 4 18 20 22;1 1 0 0 0 11 0 0 3 6 13.5 15 16.5;2 2 0 0 0 3 0 0 4 5 4.5 5 5.5;2 3 0 0 0 12 0 0 5 11 22.5 25 27.5;2 3 0 0 0 13 0 0 5 12 22.5 25 27.5;1 0 0 0 0 4 0 0 1 7 9 10 11;1 4 0 0 0 5 0 0 7 8 13.5 15 16.5;1 5 0 0 0 6  0 0 8 9 4.5 5 5.5;1 6 0 0 0 10 0 0 9 6 9 10 11;1 0 0 0 0 7 0 0 2 10 13.5 15 16.5;1 7 0 0 0 9 0 0 10 6 9 10 11;2 11 0 0 0 12 0 0 6 11 18 20 22;2 11 0 0 0 13 0 0 6 12 18 20 22;1 8 0 0 0 12 0 0 6 11 13.5 15 16.5;1 8 0 0 0 13 0 0 6 12 13.5 15 16.5;2 14 0 0 0 0 0 0 11 13 13.5 15 16.5;2 15 0 0 0 0 0 0 12 13 13.5 15 16.5]; %matrice di tutti i task da eseguire: i primi 15 valori sono i MT e i secondi 18 sono i TT (stazioni in parallelo haneo MT doppi). Colonne: 1 -> numero operatori richiesti, 2-4 attività predecessore, 5 modalità di assegnazione predecessore, 6-7 attività succeditrici, 8 modalità assegnazione succeditrici. -Notare che il ‘3’ in colonna 1 indica la necessità del saldatore (l’operatore richiesto è 1 ma è il saldatore). Colonna 9: stazione di partenza o stazione in cui deve essere svolta l’attività, colonna 10: eventuale stazione di arrivo. Le ultime 3 colonne riportano i valori min, medio e max, del tempo di processamento/durata attività.
P=[26 7 27 9 8 31 0 0 0 0 0 0 0 552; 0 0 0 0 0 30 0 0 0 0 0 0 0 15; 16 1 17 2 19 3 21 0 0 0 0 0 0 1386; 0 0 0 0 0 0 20 0 0 0 0 0 0 25; 0 0 18 0 0 0 0 0 0 0 0 0 0 15;22 4 23 5 24 6 25 10 11 29 13 15 33 4889; 0 0 0 0 0 0 0 0 0 28 12 14 32 2434]; %matrice dei percorsi; l’ultimo valore è la durata media preventivata sulla base dei dati
S=zeros(10000,43); %inizializzo S, matrice degli "stati": segna tutti gli step del codice. Qui la prima riga che è lo stato iniziale, nel ciclo andremo ad aggiungere tutti gli "stati" man mano che vengono scoperti. I valori 1:15 sono i MT; i valori 16-33 i TT; i valori 34-41 i task da assegnare (coerente con 'daassegnare'), il 42esimo indica il numero di job completati e l'ultimo l'eventuale fine (END).
tempi=zeros(10000,33); %segna l'avanzamento dei task dal punto di vista temporale
daassegnare=zeros(10000,8); %inizializzo la matrice che memorizza per ogni stato le attività che risultano da assegnare: sono 4 colonne perché le attività da assegnare in un dato stato sono al max 4 (lo si evince dalla matrice dei percorsi)
da=ones(10000,16); %se il task da assegnare è relativo al processo principale il valore è 1(default), se del primo wip, 2; se del secondo, 3; se del terzo, 4; se del quarto, 5.
daassegnareconprio=zeros(10000,16); % inizializzo la matrice che memorizzerà i task da assegnare per ogni stato, ma ordinati per priorità: le prime 4 colonne riportano i task da assegnare per ogni stato (esattamente gli stessi di daassegnare), ma ordinati secondo priorità (dal più prioritario al meno, secondo la durata attesa del percorso a cui appartiene), le ultime 4 il numero di operatori che ciascuno richiede (la colonna 5 sarà riferita al task con priorità maggiore cioè quello in posizione di colonna 1 e così via): 3 indica il saldatore, 1 e 2 gli worker necessari (se si tratta cioè di un qualsiasi task che non richieda il saldatore, cioè non vada eseguito in St5 (che in matlab è la numero6).
assegnatoconprio=zeros(10000,8); %segna i task effettivamente assegnati di 'daassegnareconprio', ossia quelli per cui sono stati trovati disponibili gli operatori necessari
durate=zeros(1,4); %vettore in cui salviamo le durate dei task da assegnare da ordinare man mano che vengono introdotti nella matrice daassegnare.
duratew=zeros(1,4); %vettore in cui salviamo le durate dei task da assegnare secondo priorità, per il wip
duratew2=zeros(1,4); %vettore in cui salviamo le durate dei task da assegnare secondo priorità, per il secondo wip
duratew3=zeros(1,4); %vettore in cui salviamo le durate dei task da assegnare secondo priorità, per il terzo wip
duratew4=zeros(1,4); %vettore in cui salviamo le durate dei task da assegnare secondo priorità, per l'eventuale quarto wip
assegnprioritaria=zeros(10000,16); %inizio costruzione della matrice che segna per ogni stato l’assegnazione ‘naturale’.
val=0; %valore da passare
p=0;
assegnato=zeros(10000,10); %memorizza gli worker che vengono assegnati nello stato corrente, in modo da non assegnarli più di una volta, e serve per completare la scrittura dello stato (S(i)) successivo, aggiungendo l'1 ai task che iniziano da lì ad essere in processamento
s=ones(10000,33); %segna se il task assegnato è relativo al processo principale o a quello del wip (1 principale, 2 primo wip, 3 secondo wip, 4 terzo wip, 5 quarto wip)
assegnatotask=zeros(10000,10); %corrispondentemente alla matrice precedente ('assegnato') specifica a quale task il lavoratore è assegnato
assegnatoop=zeros(10000,10); %segna quali operatori vengono assegnati, in ciascuno stato
k=1; %indice di colonna di trackcompletamento
q=1; %indice di colonna di 'trackwip'
qq=1; %indice di colonna di 'trackwip2'
q3=1; %indice di colonna di 'trackwip3'
q4=1; %indice di colonna di 'trackwip4'
giri=0; %segna i giri di colonne
giriw=0; %segna i giri di colonne per il wip
giriw2=0; %segna i giri di colonne per il secondo wip
giriw3=0; %segna i giri di colonne per il terzo wip
giriw4=0; %segna i giri di colonne per il quarto wip
ok=0;
trackcompletamento=[1 1 1 1 1 1 0 0 0 0 0 0 0 552; 0 0 0 0 0 1 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 0 0 0 0 0 0 1386; 0 0 0 0 0 0 1 0 0 0 0 0 0 25; 0 0 1 0 0 0 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 1 1 1 1 1 1 4889; 0 0 0 0 0 0 0 0 0 1 1 1 1 2434]; %matrice dinamica che tiene traccia dei task/percorsi da completare/completati; l’ultima riga è la durata media stimata del percorso (anch’essa dinamica, che tiene conto dei task da completare/completati), serve per definire la priorità nell’assegnazione del task.
trackassegnamento=[1 1 1 1 1 1 0 0 0 0 0 0 0; 0 0 0 0 0 1 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 0 0 0 0 0 0; 0 0 0 0 0 0 1 0 0 0 0 0 0; 0 0 1 0 0 0 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 1 1 1 1 1 1; 0 0 0 0 0 0 0 0 0 1 1 1 1]; %serve per segnare quando i task sonos tati assegnati e quando invece sono da assegnare (1 da assegnare, 0 altrimenti)
trackwip=[1 1 1 1 1 1 0 0 0 0 0 0 0 552; 0 0 0 0 0 1 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 0 0 0 0 0 0 1386; 0 0 0 0 0 0 1 0 0 0 0 0 0 25; 0 0 1 0 0 0 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 1 1 1 1 1 1 4889; 0 0 0 0 0 0 0 0 0 1 1 1 1 2434]; %matrice dinamica che tiene traccia dei task/percorsi da completare/completati, relativamente al WIP
asswip=[1 1 1 1 1 1 0 0 0 0 0 0 0; 0 0 0 0 0 1 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 0 0 0 0 0 0; 0 0 0 0 0 0 1 0 0 0 0 0 0; 0 0 1 0 0 0 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 1 1 1 1 1 1; 0 0 0 0 0 0 0 0 0 1 1 1 1]; %monitora l'assegnamento del wip
trackwip2=[1 1 1 1 1 1 0 0 0 0 0 0 0 552; 0 0 0 0 0 1 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 0 0 0 0 0 0 1386; 0 0 0 0 0 0 1 0 0 0 0 0 0 25; 0 0 1 0 0 0 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 1 1 1 1 1 1 4889; 0 0 0 0 0 0 0 0 0 1 1 1 1 2434]; %matrice dinamica che tiene traccia dei task/percorsi da completare/completati, relativamente al WIP
asswip2=[1 1 1 1 1 1 0 0 0 0 0 0 0; 0 0 0 0 0 1 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 0 0 0 0 0 0; 0 0 0 0 0 0 1 0 0 0 0 0 0; 0 0 1 0 0 0 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 1 1 1 1 1 1; 0 0 0 0 0 0 0 0 0 1 1 1 1]; %monitora l'assegnamento del wip
trackwip3=[1 1 1 1 1 1 0 0 0 0 0 0 0 552; 0 0 0 0 0 1 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 0 0 0 0 0 0 1386; 0 0 0 0 0 0 1 0 0 0 0 0 0 25; 0 0 1 0 0 0 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 1 1 1 1 1 1 4889; 0 0 0 0 0 0 0 0 0 1 1 1 1 2434]; %matrice dinamica che tiene traccia dei task/percorsi da completare/completati, relativamente al WIP
asswip3=[1 1 1 1 1 1 0 0 0 0 0 0 0; 0 0 0 0 0 1 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 0 0 0 0 0 0; 0 0 0 0 0 0 1 0 0 0 0 0 0; 0 0 1 0 0 0 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 1 1 1 1 1 1; 0 0 0 0 0 0 0 0 0 1 1 1 1]; %monitora l'assegnamento del wip
trackwip4=[1 1 1 1 1 1 0 0 0 0 0 0 0 552; 0 0 0 0 0 1 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 0 0 0 0 0 0 1386; 0 0 0 0 0 0 1 0 0 0 0 0 0 25; 0 0 1 0 0 0 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 1 1 1 1 1 1 4889; 0 0 0 0 0 0 0 0 0 1 1 1 1 2434]; %matrice dinamica che tiene traccia dei task/percorsi da completare/completati, relativamente al WIP
asswip4=[1 1 1 1 1 1 0 0 0 0 0 0 0; 0 0 0 0 0 1 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 0 0 0 0 0 0; 0 0 0 0 0 0 1 0 0 0 0 0 0; 0 0 1 0 0 0 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 1 1 1 1 1 1; 0 0 0 0 0 0 0 0 0 1 1 1 1]; %monitora l'assegnamento del wip
avanza1=0;
avanza2=0;
avanza3=0;
avanza4=0;
avanza5=0;
A=cell(10000,1);
vi=zeros(10000,10); %tiene traccia degli operatori che posso assegnare per determinare le azioni che è possibile eseguire in dato stato
vi_univ=zeros(10000,10); %vi univoci
n_vi_univ=0;
NK=zeros(5000,3); %inizializzo matrice che segna gli n, i k ed l'eventuale presenza del saldatore in modo da non segnare più volte le azioni nell'elenco delle azioni eseguibili ('azioni')
rnk=1; %indice di riga di NK
azioni=zeros(50000,8);
in=1; %segna la riga da cui iniziare per continuare a riempire la matrice 'azioni' quando necessario
t=zeros(10000,1); %segna l'avanzare del tempo simulato con ogni stato
ttemp=zeros(10000,1); %segna gli avanzamenti del tempo ad ogni stato
END=0;
Q=0;
rand=zeros(10000,4); %segnerà i valori casuali dati ai tempi di processamento delle attività
%imposto le distribuzioni di probabilità delle durate dei task:
pd=cell(33,1); %cell array che conterrà le 31 distribuzioni
for i=1:33
    pd{i}=makedist('triangular','a',task(i,11),'b',task(i,12),'c',task(i,13));
end
rngen=ones(1,33);
i=1;
%codice
while  ~END  %ciclo sugli stati
    incorso{i}=find(S(i,1:33));
    ok2=1;
    trovato=0;
    z=1; %indice di colonna di daassegnare
    zi=1; %indice di colonna di asswip
    zii=1; %indice di colonna di asswip2
    z3=1; %indice di colonna di asswip3
    z4=1; %indice di colonna di asswip4
    stepup1=0;
    stepup2=0;
    stepup3=0;
    stepup4=0;
    stepup5=0;
    while Q==0 && k<14
        for j=1:7     %ciclo sulle righe di trackcompletamento per trovare gli 1 cioè i task da assegnare
            if trackcompletamento(j,k)==1 && trackassegnamento(j,k)==1
                if (1<=P(j,k) && P(j,k)<=15 && St(i,task(P(j,k),9))==0) || P(j,k)==8 || P(j,k)==11 || P(j,k)==14 || P(j,k)==15
                    go=1;
                elseif (P(j,k)>15 && task(P(j,k),6)~=0 && St(i,task(P(j,k),10))==0 && (Stt(i,task(P(j,k),10))==0 || Stt(i,task(P(j,k),10))==1)) || ((P(j,k)==18 && trackcompletamento(6,8)==0)) || P(j,k)==32 || P(j,k)==33 %condizione su Stt si potrebbe togliere
                    go=1;
                    if (P(j,k)==27 && (w11~=0 || St(i,11)~=0) && (w12~=0 || St(i,12)~=0) && perc==0) || ((P(j,k)==27 || P(j,k)==25) && Stt(i,6)==1 ) 
                        go=0;
                    end
                else
                    go=0;
                end
                if go==1 && P(j,k)>15 && P(j,k)~=20 && P(j,k)~=21 && P(j,k)~=28 && P(j,k)~=29 && P(j,k)~=30 && P(j,k)~=31
                    nz=nonzeros(Wt(i,:));
                    for w=1:numel(nz)
                        if nz(w)>15
                            if task(nz(w),10)==task(P(j,k),10)
                                go=0;
                            end
                        end
                    end
                end
                if go==1
                    pred=task(P(j,k),2:4); %predecessori del task in questione
                    if nnz(pred)==0 
                        daassegnare(i,z)=P(j,k); 
                        durate(1,z)=P(j,14);
                        z=z+1;
                        if 1<=P(j,k) && P(j,k)<=15 && P(j,k)~=8 && P(j,k)~=11 %credo che questo ciclo si possa eliminare
                            Stt(i,task(P(j,k),9))=1;
                        elseif P(j,k)==27 || P(j,k)==25
                            Stt(i,task(P(j,k),10))=1;
                        end
                    else
                        for K=1:nnz(pred)
                            [g,h]=find(P(:,1:13)==pred(K));
                                if trackcompletamento(g,h)==0
                                    ok=ok+1;
                                        if task(pred(K),8)==2
                                            if (P(j,k)==31 || P(j,k)==21 || P(j,k)==29) && (S(i,task(P(j,k),6))==0 || (S(i,task(P(j,k),6))~=0 && S(i,task(P(j+1,k),6))~=0))
                                                if ismember(30, daassegnare(i,:)) || ismember(20, daassegnare(i,:)) || ismember(28,daassegnare(i,:)) 
                                                    ok2=0;
                                                end
                                            elseif (P(j,k)==30 || P(j,k)==20 || P(j,k)==28) && (S(i,task(P(j,k),6))==0 || (S(i,task(P(j,k),6))~=0 && S(i,task(P(j+1,k),6))~=0))
                                                if ismember(31, daassegnare(i,:)) || ismember(21, daassegnare(i,:)) || ismember(29,daassegnare(i,:))
                                                    ok2=0;
                                                end
                                            end
                                        end
                                        if ok==nnz(pred) && ok2==1
                                            if P(j,k)==18
                                                if trackcompletamento(6,8)==0
                                                    daassegnare(i,z)=P(j,k);
                                                    durate(1,z)=trackcompletamento(j,14);
                                                    z=z+1;
                                                    trovato=1;
                                                end
                                            else
                                                daassegnare(i,z)=P(j,k);
                                                durate(1,z)=trackcompletamento(j,14);
                                                z=z+1;
                                                trovato=1;
                                                if 1<=P(j,k) && P(j,k)<=15 && P(j,k)~=8 && P(j,k)~=10 && P(j,k)~=11
                                                    Stt(i,task(P(j,k),9))=1;
                                                elseif P(j,k)==25 || P(j,k)==27
                                                        Stt(i,task(P(j,k),10))=1;
                                                end
                                            end
                                        end
                                end
                        end
                        ok=0;
                    end
                end
            end
        end
        
        if (j==7 && k>1 && trovato==0 && numel(nonzeros(trackassegnamento(:,k)))==numel(nonzeros(P(:,k))) ) || k==14
                Q=1;
        else
            k=k+1;
            giri=giri+1;
        end
    end
    if nnz(daassegnare(i,:))==0
        stepup1=1;
    end
    Q=0;
    k=k-giri;
    giri=0;
    b1=nnz(daassegnare(i,:));
   
    ok2=1;
    trovato=0;
    while Q==0 && q<14
        for j=1:7   %ciclo sulle righe di trackwip 
            if trackcompletamento(j,q)==0 && trackwip(j,q)==1 && asswip(j,q)==1
                if (1<=P(j,q) && P(j,q)<=15 && St(i,task(P(j,q),9))==0)|| P(j,q)==8 || P(j,q)==11 || P(j,q)==14 || P(j,q)==15
                    go=1;
                elseif (P(j,q)>15 && task(P(j,q),6)~=0 && St(i,task(P(j,q),10))==0 && (Stt(i,task(P(j,q),10))==0 || Stt(i,task(P(j,q),10))==2)) || ((P(j,q)==18 && trackwip(6,8)==0)) || P(j,q)==32 || P(j,q)==33
                    go=1;
                    if ((P(j,q)==30 || P(j,q)==28 || P(j,q)==20) && w12==1 && percw~=2) || ((P(j,q)==31 || P(j,q)==29 || P(j,q)==21) && w11==1 && percw~=1)
                        go=0;
                    end
                    if (P(j,q)==27 && (w11~=0 || St(i,11)~=0) && (w12~=0 || St(i,12)~=0) && percw==0) || ((P(j,q)==27 || P(j,q)==25) && Stt(i,6)==2 )
                        go=0;
                    end
                else
                    go=0;
                end
                if go==1 && P(j,q)>15 && P(j,q)~=20 && P(j,q)~=21 && P(j,q)~=28 && P(j,q)~=29 && P(j,q)~=30 && P(j,q)~=31
                    nz=nonzeros(Wt(i,:));
                    for w=1:numel(nz)
                        if nz(w)>15
                            if task(nz(w),10)==task(P(j,q),10)
                                go=0;
                            end
                        end
                    end
                end
                if go==1
                    pred=task(P(j,q),2:4); %predecessori del task in questione
                    if nnz(pred)==0
                        daassegnare(i,z)=P(j,q);
                        da(i,z)=2;
                        duratew(1,zi)=P(j,14);
                        z=z+1;
                        zi=zi+1;
                        if 1<=P(j,q) && P(j,q)<=15 && P(j,q)~=8 && P(j,q)~=11
                            Stt(i,task(P(j,q),9))=2;
                        elseif P(j,q)==25 || P(j,q)==27
                            Stt(i,task(P(j,q),10))=2;
                        end
                    else
                        for K=1:nnz(pred)
                            if P(j,q)==18
                                if trackwip(6,8)==0
                                    ok4=1;
                                end
                            end
                            [g,h]=find(P(:,1:13)==pred(K));
                                if trackwip(g,h)==0
                                    ok=ok+1;
                                        if task(pred(K),8)==2
                                            if (P(j,q)==31 || P(j,q)==21 || P(j,q)==29) && (S(i,task(P(j,q),6))==0 || (S(i,task(P(j,q),6))~=0 && S(i,task(P(j+1,q),6))~=0)) 
                                                if ismember(30, daassegnare(i,b1+1:end)) || ismember(20, daassegnare(i,b1+1:end)) || ismember(28,daassegnare(i,b1+1:end)) 
                                                    ok2=0;
                                                end
                                            elseif (P(j,q)==30 || P(j,q)==20 || P(j,q)==28) && (S(i,task(P(j,q),6))==0 || (S(i,task(P(j,q),6))~=0 && S(i,task(P(j+1,q),6))~=0)) 
                                                if ismember(31, daassegnare(i,b1+1:end)) || ismember(21, daassegnare(i,b1+1:end)) || ismember(29,daassegnare(i,b1+1:end)) 
                                                    ok2=0;
                                                end
                                            end
                                        end
                                        if ok==nnz(pred) && ok2==1
                                            if P(j,q)==18
                                                if trackwip(6,8)==0
                                                    daassegnare(i,z)=P(j,q);
                                                    da(i,z)=2;
                                                    duratew(1,zi)=trackwip(j,14);
                                                    z=z+1;
                                                    zi=zi+1;
                                                    trovato=1;
                                                end
                                            else
                                                daassegnare(i,z)=P(j,q);
                                                    da(i,z)=2;
                                                    duratew(1,zi)=trackwip(j,14);
                                                    z=z+1;
                                                    zi=zi+1;
                                                    trovato=1;
                                                    if 1<=P(j,q) && P(j,q)<=15 && P(j,q)~=8 && P(j,q)~=11
                                                        Stt(i,task(P(j,q),9))=1;
                                                    elseif P(j,q)==25 || P(j,q)==27
                                                        Stt(i,task(P(j,q),10))=1;
                                                    end
                                            end
                                        end
                                end
                        end
                        ok=0;
                    end
                end
            end
        end
        if (j==7 && q>1 && trovato==0 && numel(nonzeros(asswip(:,q)))==numel(nonzeros(P(:,q))) ) || q==14
                Q=1;
        else
            q=q+1;
            giriw=giriw+1;
        end
    end
    if nnz(daassegnare(i,b1+1:end))==0
        stepup2=1;
    end
    Q=0;
    q=q-giriw;
    giriw=0;
    b2=nnz(daassegnare(i,b1+1:end));
    
    ok2=1;
    trovato=0;
    while Q==0 && qq<14
        for j=1:7   %ciclo sulle righe di trackwip2
            if trackcompletamento(j,qq)==0 && trackwip(j,qq)==0 && trackwip2(j,qq)==1 && asswip2(j,qq)==1
                if (1<=P(j,qq) && P(j,qq)<=15 && St(i,task(P(j,qq),9))==0) || P(j,qq)==8 || P(j,qq)==11 || P(j,qq)==14 || P(j,qq)==15
                    go=1;
                elseif (P(j,qq)>15 && task(P(j,qq),6)~=0 && St(i,task(P(j,qq),10))==0 && (Stt(i,task(P(j,qq),10))==0 || Stt(i,task(P(j,qq),10))==3)) || ((P(j,qq)==18 && trackwip2(6,8)==0)) || P(j,qq)==32 || P(j,qq)==33
                    go=1;
                    if ((P(j,qq)==30 || P(j,qq)==28 || P(j,qq)==20) && w12==1 && percw2~=2) || ((P(j,qq)==31 || P(j,qq)==29 || P(j,qq)==21) && w11==1 && percw2~=1)
                        go=0;
                    end
                    if (P(j,qq)==27 && (w11~=0 || St(i,11)~=0) && (w12~=0 || St(i,12)~=0) && percw2==0) || ((P(j,qq)==27 || P(j,qq)==25) && Stt(i,6)==1 )
                        go=0;
                    end
                else
                    go=0;
                end
                if go==1 && P(j,qq)>15 && P(j,qq)~=20 && P(j,qq)~=21 && P(j,qq)~=28 && P(j,qq)~=29 && P(j,qq)~=30 && P(j,qq)~=31
                    nz=nonzeros(Wt(i,:));
                    for w=1:numel(nz)
                        if nz(w)>15
                            if task(nz(w),10)==task(P(j,qq),10)
                                go=0;
                            end
                        end
                    end
                end
                if go==1
                    pred=task(P(j,qq),2:4); %predecessori del task in questione
                    if nnz(pred)==0
                        daassegnare(i,z)=P(j,qq);
                        da(i,z)=3;
                        duratew2(1,zii)=P(j,14);
                        z=z+1;
                        zii=zii+1;
                        if 1<=P(j,qq) && P(j,qq)<=15 && P(j,qq)~=8 && P(j,qq)~=11
                            Stt(i,task(P(j,qq),9))=3;
                        elseif P(j,qq)==25 || P(j,qq)==27
                            Stt(i,task(P(j,qq),10))=3;
                        end
                    else
                        for K=1:nnz(pred)
                            if P(j,qq)==18
                                if trackwip2(6,8)==0
                                    ok4=1;
                                end
                            end
                            [g,h]=find(P(:,1:13)==pred(K));
                                if trackwip2(g,h)==0
                                    ok=ok+1;
                                        if task(pred(K),8)==2
                                            if (P(j,qq)==31 || P(j,qq)==21 || P(j,qq)==29) && (S(i,task(P(j,qq),6))==0 || (S(i,task(P(j,qq),6))~=0 && S(i,task(P(j+1,qq),6))~=0))
                                                if ismember(30, daassegnare(i,b2+1:end)) || ismember(20, daassegnare(i,b2+1:end)) || ismember(28,daassegnare(i,b2+1:end)) 
                                                    ok2=0;
                                                end
                                            elseif (P(j,qq)==30 || P(j,qq)==20 || P(j,qq)==28) && (S(i,task(P(j,qq),6))==0 || (S(i,task(P(j,qq),6))~=0 && S(i,task(P(j+1,qq),6))~=0))
                                                if ismember(31, daassegnare(i,b2+1:end)) || ismember(21, daassegnare(i,b2+1:end)) || ismember(29,daassegnare(i,b2+1:end)) 
                                                    ok2=0;
                                                end
                                            end
                                        end
                                        if ok==nnz(pred) && ok2==1
                                            if P(j,qq)==18
                                                if trackwip2(6,8)==0
                                                    daassegnare(i,z)=P(j,qq);
                                                    da(i,z)=3;
                                                    duratew2(1,zii)=trackwip2(j,14);
                                                    z=z+1;
                                                    zii=zii+1;        
                                                    trovato=1;
                                                end
                                            else
                                                    daassegnare(i,z)=P(j,qq);
                                                    da(i,z)=3;
                                                    duratew2(1,zii)=trackwip2(j,14);
                                                    z=z+1;
                                                    zii=zii+1;
                                                    trovato=1;
                                                    if 1<=P(j,qq) && P(j,qq)<=15 && P(j,qq)~=8 && P(j,qq)~=11
                                                        Stt(i,task(P(j,qq),9))=1;
                                                    elseif P(j,qq)==25 || P(j,qq)==27
                                                        Stt(i,task(P(j,qq),10))=1;
                                                    end
                                            end
                                        end
                                end
                        end
                        ok=0;
                    end
                end
            end
        end
        if (j==7 && qq>1 && trovato==0 && numel(nonzeros(asswip2(:,qq)))==numel(nonzeros(P(:,qq))) ) || qq==14
                Q=1;
        else
            qq=qq+1;
            giriw2=giriw2+1;
        end
    end
    if nnz(daassegnare(i,b1+b2+1:end))==0
        stepup3=1;
    end
    Q=0;
    qq=qq-giriw2;
    giriw2=0;
    b3=nnz(daassegnare(i,b1+b2+1:end));
    
    ok2=1;
    trovato=0;
    while Q==0 && q3<14
        for j=1:7   %ciclo sulle righe di trackwip2
            if trackcompletamento(j,q3)==0 && trackwip(j,q3)==0 && trackwip2(j,q3)==0 && trackwip3(j,q3)==1 && asswip3(j,q3)==1
                if (1<=P(j,q3) && P(j,q3)<=15 && St(i,task(P(j,q3),9))==0) || P(j,q3)==8 || P(j,q3)==11 || P(j,q3)==14 || P(j,q3)==15
                    go=1;
                elseif (P(j,q3)>15 && task(P(j,q3),6)~=0 && St(i,task(P(j,q3),10))==0 && (Stt(i,task(P(j,q3),10))==0 || Stt(i,task(P(j,q3),10))==4)) || ((P(j,q3)==18 && trackwip3(6,8)==0)) || P(j,q3)==32 || P(j,q3)==33
                    go=1;
                    if ((P(j,q3)==30 || P(j,q3)==28 || P(j,q3)==20) && w12==1 && percw3~=2) || ((P(j,q3)==31 || P(j,q3)==29 || P(j,q3)==21) && w11==1 && percw3~=1)
                        go=0;
                    end
                    if (P(j,q3)==27 && (w11~=0 || St(i,11)~=0) && (w12~=0 || St(i,12)~=0) && percw3==0) || ((P(j,q3)==27 || P(j,q3)==25) && Stt(i,6)==1 )
                        go=0;
                    end
                else
                    go=0;
                end
                if go==1 && P(j,q3)>15 && P(j,q3)~=20 && P(j,q3)~=21 && P(j,q3)~=28 && P(j,q3)~=29 && P(j,q3)~=30 && P(j,q3)~=31
                    nz=nonzeros(Wt(i,:));
                    for w=1:numel(nz)
                        if nz(w)>15
                            if task(nz(w),10)==task(P(j,q3),10)
                                go=0;
                            end
                        end
                    end
                end
                if go==1
                    pred=task(P(j,q3),2:4); %predecessori del task in questione
                    if nnz(pred)==0
                        daassegnare(i,z)=P(j,q3);
                        da(i,z)=4;
                        duratew3(1,z3)=P(j,14);
                        z=z+1;
                        z3=z3+1;
                        if 1<=P(j,q3) && P(j,q3)<=15 && P(j,q3)~=8 && P(j,q3)~=11
                            Stt(i,task(P(j,q3),9))=4;
                        elseif P(j,q3)==25 || P(j,q3)==27
                            Stt(i,task(P(j,q3),10))=4;
                        end
                    else
                        for K=1:nnz(pred)
                            if P(j,q3)==18
                                if trackwip3(6,8)==0
                                    ok4=1;
                                end
                            end
                            [g,h]=find(P(:,1:13)==pred(K));
                                if trackwip3(g,h)==0
                                    ok=ok+1;
                                        if task(pred(K),8)==2
                                            if (P(j,q3)==31 || P(j,q3)==21 || P(j,q3)==29) && (S(i,task(P(j,q3),6))==0 || (S(i,task(P(j,q3),6))~=0 && S(i,task(P(j+1,q3),6))~=0))
                                                if ismember(30, daassegnare(i,b3+1:end)) || ismember(20, daassegnare(i,b3+1:end)) || ismember(28,daassegnare(i,b3+1:end)) 
                                                    ok2=0;
                                                end
                                            elseif (P(j,q3)==30 || P(j,q3)==20 || P(j,q3)==28) && (S(i,task(P(j,q3),6))==0 || (S(i,task(P(j,q3),6))~=0 && S(i,task(P(j+1,q3),6))~=0))
                                                if ismember(31, daassegnare(i,b3+1:end)) || ismember(21, daassegnare(i,b3+1:end)) || ismember(29,daassegnare(i,b3+1:end)) 
                                                    ok2=0;
                                                end
                                            end
                                        end
                                        if ok==nnz(pred) && ok2==1
                                            if P(j,q3)==18
                                                if trackwip3(6,8)==0
                                                    daassegnare(i,z)=P(j,q3);
                                                    da(i,z)=4;
                                                    duratew3(1,z3)=trackwip3(j,14);
                                                    z=z+1;
                                                    z3=z3+1;
                                                    trovato=1;
                                                end
                                            else
                                                daassegnare(i,z)=P(j,q3);
                                                    da(i,z)=4;
                                                    duratew3(1,z3)=trackwip3(j,14);
                                                    z=z+1;
                                                    z3=z3+1;
                                                    trovato=1;
                                                    if 1<=P(j,q3) && P(j,q3)<=15 && P(j,q3)~=8 && P(j,q3)~=11
                                                        Stt(i,task(P(j,q3),9))=1;
                                                    elseif P(j,q3)==25 || P(j,q3)==27
                                                        Stt(i,task(P(j,q3),10))=1;
                                                    end
                                            end
                                        end
                                end
                        end
                        ok=0;
                    end
                end
            end
        end
        if (j==7 && q3>1 && trovato==0 && numel(nonzeros(asswip3(:,q3)))==numel(nonzeros(P(:,q3))) ) || q3==14
                Q=1;
        else
            q3=q3+1;
            giriw3=giriw3+1;
        end
    end
    if nnz(daassegnare(i,b1+b2+b3+1:end))==0
        stepup4=1;
    end
    Q=0;
    q3=q3-giriw3;
    giriw3=0;
    b4=nnz(daassegnare(i,b1+b2+b3+1:end));
    
    ok2=1;
    trovato=0;
    while Q==0 && q4<14
        for j=1:7   %ciclo sulle righe di trackwip2
            if trackcompletamento(j,q4)==0 && trackwip(j,q4)==0 && trackwip2(j,q4)==0 && trackwip3(j,q4)==0 && trackwip4(j,q4)==1 && asswip4(j,q4)==1
                if (1<=P(j,q4) && P(j,q4)<=15 && St(i,task(P(j,q4),9))==0) || P(j,q4)==8 || P(j,q4)==11 || P(j,q4)==14 || P(j,q4)==15
                    go=1;
                elseif (P(j,q4)>15 && task(P(j,q4),6)~=0 && St(i,task(P(j,q4),10))==0 && Stt(i,task(P(j,q4),10))==0) || ((P(j,q4)==18 && trackwip4(6,8)==0)) || P(j,q4)==32 || P(j,q4)==33
                    go=1;
                    if (P(j,q4)==27 && (w11~=0 || St(i,11)~=0) && (w12~=0 || St(i,12)~=0) && percw4==0) || ((P(j,q4)==27 || P(j,q4)==25) && Stt(i,6)==1 )
                        go=0;
                    end
                    if P(j,q4)==27 && (w11~=0 || St(i,11)~=0) && (w12~=0 || St(i,12)~=0)
                        go=0;
                    end
                else
                    go=0;
                end
                if go==1 && P(j,q4)>15 && P(j,q4)~=20 && P(j,q4)~=21 && P(j,q4)~=28 && P(j,q4)~=29 && P(j,q4)~=30 && P(j,q4)~=31
                    nz=nonzeros(Wt(i,:));
                    for w=1:numel(nz)
                        if nz(w)>15
                            if task(nz(w),10)==task(P(j,q4),10)
                                go=0;
                            end
                        end
                    end
                end
                if go==1
                    pred=task(P(j,q4),2:4); %predecessori del task in questione
                    if nnz(pred)==0
                        daassegnare(i,z)=P(j,q4);
                        da(i,z)=5;
                        duratew4(1,z4)=P(j,14);
                        z=z+1;
                        z4=z4+1;
                    else
                        for K=1:nnz(pred)
                            if P(j,q4)==18
                                if trackwip4(6,8)==0
                                    ok4=1;
                                end
                            end
                            [g,h]=find(P(:,1:13)==pred(K));
                                if trackwip4(g,h)==0
                                    ok=ok+1;
                                        if task(pred(K),8)==2
                                            if (P(j,q4)==31 || P(j,q4)==21 || P(j,q4)==29) && (S(i,task(P(j,q4),6))==0 || (S(i,task(P(j,q4),6))~=0 && S(i,task(P(j+1,q4),6))~=0))
                                                if ismember(30, daassegnare(i,b4+1:end)) || ismember(20, daassegnare(i,b4+1:end)) || ismember(28,daassegnare(i,b4+1:end)) 
                                                    ok2=0;
                                                end
                                            elseif (P(j,q4)==30 || P(j,q4)==20 || P(j,q4)==28) && (S(i,task(P(j,q4),6))==0 || (S(i,task(P(j,q4),6))~=0 && S(i,task(P(j+1,q4),6))~=0))
                                                if ismember(31, daassegnare(i,b4+1:end)) || ismember(21, daassegnare(i,b4+1:end)) || ismember(29,daassegnare(i,b4+1:end)) 
                                                    ok2=0;
                                                end
                                            end
                                        end
                                        if ok==nnz(pred) && ok2==1
                                            if P(j,q4)==18
                                                if trackwip4(6,8)==0
                                                    daassegnare(i,z)=P(j,q4);
                                                    da(i,z)=5;
                                                    duratew4(1,z4)=trackwip4(j,14);
                                                    z=z+1;
                                                    z4=z4+1;
                                                    trovato=1;
                                                end
                                            else
                                                daassegnare(i,z)=P(j,q4);
                                                    da(i,z)=5;
                                                    duratew4(1,z4)=trackwip4(j,14);
                                                    z=z+1;
                                                    z4=z4+1;
                                                    trovato=1;
                                            end
                                        end
                                end
                        end
                        ok=0;
                    end
                end
            end
        end
        if (j==7 && 4>1 && trovato==0 && numel(nonzeros(asswip4(:,qq)))==numel(nonzeros(P(:,q4))) ) || q4==14
                Q=1;
        else
            q4=q4+1;
            giriw4=giriw4+1;
        end
    end
    if nnz(daassegnare(i,b1+b2+b3+b4+1:end))==0
        stepup5=1;
    end
    Q=0;
    q4=q4-giriw4;
    giriw4=0;
    b5=nnz(daassegnare(i,b1+b2+b3+b4+1:end));
    
    for j=1:nnz(daassegnare(i,:))
        if daassegnare(i,j)~=8 && daassegnare(i,j)~=9 && daassegnare(i,j)~=10 && daassegnare(i,j)~=11
            nteo(i)=nteo(i)+task(daassegnare(i,j),1);
        end
    end
    
    if (stepup1~=1) || (stepup2~=1) || (stepup3~=1) || (stepup4~=1) || (stepup5~=1)
        for j=1:b1
            S(i,33+j)=daassegnare(i,j);
        end
        for j=1:b2
            S(i,33+b1+j)=daassegnare(i,b1+j);
        end
        for j=1:b3
            S(i,33+b1+b2+j)=daassegnare(i,b1+b2+j);
        end
        for j=1:b4
            S(i,33+b1+b2+b3+j)=daassegnare(i,b1+b2+b3+j);
        end
        for j=1:b5
            S(i,33+b1+b2+b3+b4+j)=daassegnare(i,b1+b2+b3+b4+j);
        end
        [~,I]=sort(durate,'descend');
        daassegnareconprio(i,1:b1)=daassegnare(i,I(1:b1));
        durate=zeros(1,4);
        [~,I]=sort(duratew,'descend');
        daassegnareconprio(i,b1+1:b1+b2)=daassegnare(i,b1+I(1:b2));
        duratew=zeros(1,4);
        [~,I]=sort(duratew2,'descend');
        daassegnareconprio(i,b1+b2+1:b1+b2+b3)=daassegnare(i,b1+b2+I(1:b3));
        duratew2=zeros(1,4);
        [~,I]=sort(duratew3,'descend');
        daassegnareconprio(i,b1+b2+b3+1:b1+b2+b3+b4)=daassegnare(i,b1+b2+b3+I(1:b4));
        duratew3=zeros(1,4);
        [~,I]=sort(duratew4,'descend');
        daassegnareconprio(i,b1+b2+b3+b4+1:b1+b2+b3+b4+b5)=daassegnare(i,b1+b2+b3+b4+I(1:b5));
        duratew4=zeros(1,4);
        K=nnz(daassegnareconprio(i,:)); %definisco il limite per il ciclo immediatamente successivo che userò per segnare nelle restanti colonne di daassegnareconprio gli operatori che ciascun task da assegnare richiede
        for j=1:K %ciclo per segnare quanti operatori richiede ciascun task da assegnare
            daassegnareconprio(i,8+j)=task(daassegnareconprio(i,j),1);
            if da(i,j)==2
                da(i,8+j)=2;
            elseif da(i,j)==3
                da(i,8+j)=3;
            elseif da(i,j)==4
                da(i,8+j)=4;
            elseif da(i,j)==5
                da(i,8+j)=5;    
            end
        end 
        j=1;
        p=0;
        while daassegnareconprio(i,j)~=0 && j<=8
            if daassegnareconprio(i,j)>=1 && daassegnareconprio(i,j)<=15
                if daassegnareconprio(i,j)>=8 && daassegnareconprio(i,j)<=11
                    if W(i,10)==0 && assegnato(i,10)==0
                        assegnprioritaria(i,j)=10; 
                        assegnato(i,10)=1;
                        assegnatoop(i,10)=10;
                        assegnatotask(i,10)=daassegnareconprio(i,j);
                        assegnatoconprio(i,j)=daassegnareconprio(i,j);
                        if da(i,j)==2
                            s(i,daassegnareconprio(i,j))=2;
                        elseif da(i,j)==3
                            s(i,daassegnareconprio(i,j))=3;
                        elseif da(i,j)==4
                            s(i,daassegnareconprio(i,j))=4;
                        elseif da(i,j)==5
                            s(i,daassegnareconprio(i,j))=5;    
                        end
                    end 
                else
                    for z=1:task(daassegnareconprio(i,j),1) 
                        min=0;
                        flag=0;
                        for w=1:9 
                            if W(i,w)==0 && assegnato(i,w)==0
                                if 	min==0 && flag==0
                                    min=dist(Wp(i,w),task(daassegnareconprio(i,j),9));
                                    if z==1
                                        assegnprioritaria(i,j)=w;
                                    else
                                        assegnprioritaria(i,7+z+p)=w;
                                    end
                                    flag=1;
                                elseif dist(Wp(i,w),task(daassegnareconprio(i,j),9))<min
                                    min=dist(Wp(i,w),task(daassegnareconprio(i,j),9)); 
                                    if z==1
                                        assegnprioritaria(i,j)=w;
                                    else
                                        assegnprioritaria(i,7+z+p)=w;
                                    end
                                end 
                            end 
                        end
                        if z==1 && task(daassegnareconprio(i,j),1)==1
                            if assegnprioritaria(i,j)~=0
                                val=assegnprioritaria(i,j);
                                assegnato(i,val)=1;
                                assegnatoop(i,val)=val;
                                assegnatotask(i,val)=daassegnareconprio(i,j);
                                assegnatoconprio(i,j)=daassegnareconprio(i,j);
                                if da(i,j)==2
                                    s(i,daassegnareconprio(i,j))=2;
                                elseif da(i,j)==3
                                    s(i,daassegnareconprio(i,j))=3;
                                elseif da(i,j)==4
                                    s(i,daassegnareconprio(i,j))=4;
                                elseif da(i,j)==5
                                    s(i,daassegnareconprio(i,j))=5;
                                end
                            end
                        elseif z==1 && assegnprioritaria(i,j)~=0
                            val_1=assegnprioritaria(i,j);
                            assegnato(i,val_1)=1;
                        elseif z==2 && assegnprioritaria(i,j)~=0 && assegnprioritaria(i,7+z+p)~=0
                                assegnato(i,val_1)=1;
                                assegnatoop(i,val_1)=val_1;
                                assegnatotask(i,val_1)=daassegnareconprio(i,j);
                                assegnatoconprio(i,j)=daassegnareconprio(i,j);
                                if da(i,j)==2
                                    s(i,daassegnareconprio(i,j))=2;
                                elseif da(i,j)==3
                                    s(i,daassegnareconprio(i,j))=3;
                                elseif da(i,j)==4
                                    s(i,daassegnareconprio(i,j))=4;
                                elseif da(i,j)==5
                                    s(i,daassegnareconprio(i,j))=5;
                                end
                                val=assegnprioritaria(i,7+z+p);
                                assegnato(i,val)=1;
                                assegnatoop(i,val)=val;
                                assegnatotask(i,val)=daassegnareconprio(i,j);
                                if da(i,8+j)==2
                                    s(i,daassegnareconprio(i,j))=2;
                                elseif da(i,8+j)==3
                                    s(i,daassegnareconprio(i,j))=3;
                                elseif da(i,8+j)==4
                                    s(i,daassegnareconprio(i,j))=4;
                                elseif da(i,8+j)==5
                                    s(i,daassegnareconprio(i,j))=5;
                                end
                        elseif z==2 && val_1~=0 && assegnprioritaria(i,7+z+p)==0
                            assegnato(i,val_1)=0;
                            neo(i)=1;
                            assegnprioritaria(i,j)=0;
                        end
                    end 
                end
            else
                for z=1:task(daassegnareconprio(i,j),1)
                    min=0; 
                    for w=1:9 
                        if W(i,w)==0 && assegnato(i,w)==0
                            if min==0 
                                min=dist(Wp(i,w),task(daassegnareconprio(i,j),9))+dist(task(daassegnareconprio(i,j),9), task(daassegnareconprio(i,j),10));
                                if z==1
                                    assegnprioritaria(i,j)=w;
                                else
                                    assegnprioritaria(i,7+z+p)=w;
                                end
                            elseif dist(Wp(i,w),task(daassegnareconprio(i,j),9))+dist(task(daassegnareconprio(i,j),9), task(daassegnareconprio(i,j),10))<min
                                min=dist(Wp(i,w),task(daassegnareconprio(i,j),9))+dist(task(daassegnareconprio(i,j),9), task(daassegnareconprio(i,j),10));
                                    if z==1
                                        assegnprioritaria(i,j)=w;
                                    else
                                        assegnprioritaria(i,7+z+p)=w;
                                    end
                            end 
                        end 
                    end 
                    if z==1 && task(daassegnareconprio(i,j),1)==1
                        if assegnprioritaria(i,j)~=0
                            val=assegnprioritaria(i,j);
                            assegnato(i,val)=1;
                            assegnatoop(i,val)=val;
                            assegnatotask(i,val)=daassegnareconprio(i,j);
                            assegnatoconprio(i,j)=daassegnareconprio(i,j);
                            if da(i,j)==2
                                s(i,daassegnareconprio(i,j))=2;
                            elseif da(i,j)==3
                                s(i,daassegnareconprio(i,j))=3;
                            elseif da(i,j)==4
                                s(i,daassegnareconprio(i,j))=4;
                            elseif da(i,j)==5
                                s(i,daassegnareconprio(i,j))=5;
                            end
                        end
                    elseif z==1 && assegnprioritaria(i,j)~=0
                        val_1=assegnprioritaria(i,j);
                        assegnato(i,val_1)=1;
                    elseif z==1 && assegnprioritaria(i,j)==0
                        break
                    elseif z==2 && assegnprioritaria(i,j)~=0 && assegnprioritaria(i,7+z+p)~=0
                        assegnato(i,val_1)=1;
                        assegnatoop(i,val_1)=val_1;
                        assegnatotask(i,val_1)=daassegnareconprio(i,j);
                        assegnatoconprio(i,j)=daassegnareconprio(i,j);
                        if da(i,j)==2
                            s(i,daassegnareconprio(i,j))=2;
                        elseif da(i,j)==3
                            s(i,daassegnareconprio(i,j))=3;
                        elseif da(i,j)==4
                            s(i,daassegnareconprio(i,j))=4;
                        elseif da(i,j)==5
                            s(i,daassegnareconprio(i,j))=5;
                        end
                        val=assegnprioritaria(i,7+z+p);
                        assegnato(i,val)=1;
                        assegnatoop(i,val)=val;
                        assegnatotask(i,val)=daassegnareconprio(i,j);
                        if da(i,8+j)==2
                            s(i,daassegnareconprio(i,j))=2;
                        elseif da(i,8+j)==3
                            s(i,daassegnareconprio(i,j))=3;
                        elseif da(i,8+j)==4
                            s(i,daassegnareconprio(i,j))=4;
                        elseif da(i,8+j)==5
                            s(i,daassegnareconprio(i,j))=5;
                        end
                    elseif z==2 && val_1~=0 && assegnprioritaria(i,7+z+p)==0
                        assegnato(i,val_1)=0;
                        assegnprioritaria(i,find(assegnprioritaria(i,:)==val_1))=0;
                        neo(i)=1;
                    end
                end
            end
            p=p+task(daassegnareconprio(i,j),1);
            j=j+1;
            val=0;
            val_1=0;
            % setto il valore della distanza minima a zero ogni volta che eseguo il ciclo (devo trovare la distanza minima dell’operatore dal task richiesto e assegnarlo, se disponibile, Ɐ task, Ɐ operatore che questo richiede, escluso i task 8:11 che richiedono il saldatore quindi non è necessario calcolo di distanza ma solo verifica disponibilità di quest’ultimo)
        end
        x=nnz(assegnatoconprio(i,:));
        assegnatoconprio(i,1:x)=nonzeros(assegnatoconprio(i,:));
        assegnatoconprio(i,x+1:8)=zeros(1,8-x);
        for j=1:x
            if assegnatoconprio(i,j)~=8 && assegnatoconprio(i,j)~=9 && assegnatoconprio(i,j)~=10 && assegnatoconprio(i,j)~=11
                enne(i)=enne(i)+task(assegnatoconprio(i,j),1);
            end
                if assegnatoconprio(i,j)==31 || assegnatoconprio(i,j)==30 || assegnatoconprio(i,j)==21 || assegnatoconprio(i,j)==20 || assegnatoconprio(i,j)==29 || assegnatoconprio(i,j)==28
                    if perc==0
                        if b1~=0 && (assegnatoconprio(i,j)==31 || assegnatoconprio(i,j)==21 || assegnatoconprio(i,j)==29 && ismember(assegnatoconprio(i,j),daassegnare(i,1:b1)))
                            trackassegnamento(2,6)=0;
                            trackcompletamento(2,6)=0;
                            trackassegnamento(4,7)=0;
                            trackcompletamento(4,7)=0;
                            trackassegnamento(7,10)=0;
                            trackcompletamento(7,10)=0;
                            trackassegnamento(7,11)=0;
                            trackcompletamento(7,11)=0;
                            trackassegnamento(7,12)=0;
                            trackcompletamento(7,12)=0;
                            trackassegnamento(7,12)=0;
                            trackcompletamento(7,13)=0;
                            trackassegnamento(7,13)=0;
                        end
                        if b1~=0 && (assegnatoconprio(i,j)==30 || assegnatoconprio(i,j)==20 || assegnatoconprio(i,j)==28) && ismember(assegnatoconprio(i,j),daassegnare(i,1:b1))
                            trackassegnamento(1,6)=0;
                            trackcompletamento(1,6)=0;
                            trackassegnamento(3,7)=0;
                            trackcompletamento(3,7)=0;
                            trackassegnamento(6,10)=0;
                            trackcompletamento(6,10)=0;
                            trackassegnamento(6,11)=0;
                            trackcompletamento(6,11)=0;
                            trackassegnamento(6,12)=0;
                            trackcompletamento(6,12)=0;
                            trackassegnamento(6,13)=0;
                            trackcompletamento(6,13)=0;
                        end
                    end
                    if percw==0
                        if b2~=0 && (assegnatoconprio(i,j)==31 || assegnatoconprio(i,j)==21 || assegnatoconprio(i,j)==29) && ismember(assegnatoconprio(i,j),daassegnare(i,b1+1:b1+b2))
                            asswip(2,6)=0;
                            trackwip(2,6)=0;
                            asswip(4,7)=0;
                            trackwip(4,7)=0;
                            asswip(7,10)=0;
                            trackwip(7,10)=0;
                            asswip(7,11)=0;
                            trackwip(7,11)=0;
                            asswip(7,12)=0;
                            trackwip(7,12)=0;
                            asswip(7,12)=0;
                            trackwip(7,13)=0;
                        end
                        if b2~=0 && (assegnatoconprio(i,j)==30 || assegnatoconprio(i,j)==20 || assegnatoconprio(i,j)==28) && ismember(assegnatoconprio(i,j),daassegnare(i,b1+1:b1+b2))
                            asswip(1,6)=0;
                            trackwip(1,6)=0;
                            asswip(3,7)=0;
                            trackwip(3,7)=0;
                            asswip(6,10)=0;
                            trackwip(6,10)=0;
                            asswip(6,11)=0;
                            trackwip(6,11)=0;
                            asswip(6,12)=0;
                            trackwip(6,12)=0;
                            asswip(6,13)=0;
                            trackwip(6,13)=0;
                        end
                    end
                    if percw2==0
                        if b3~=0 && (assegnatoconprio(i,j)==31 || assegnatoconprio(i,j)==21 || assegnatoconprio(i,j)==29) && ismember(assegnatoconprio(i,j),daassegnare(i,b1+b2+1:b1+b2+b3)) 
                            asswip2(2,6)=0;
                            trackwip2(2,6)=0;
                            asswip2(4,7)=0;
                            trackwip2(4,7)=0;
                            asswip2(7,10)=0;
                            trackwip2(7,10)=0;
                            asswip2(7,11)=0;
                            trackwip2(7,11)=0;
                            asswip2(7,12)=0;
                            trackwip2(7,12)=0;
                            asswip2(7,12)=0;
                            trackwip2(7,13)=0;
                        end
                        if b3~=0 && (assegnatoconprio(i,j)==30 || assegnatoconprio(i,j)==20 || assegnatoconprio(i,j)==28) && ismember(assegnatoconprio(i,j),daassegnare(i,b1+b2+1:b1+b2+b3))
                            asswip2(1,6)=0;
                            trackwip2(1,6)=0;
                            asswip2(3,7)=0;
                            trackwip2(3,7)=0;
                            asswip2(6,10)=0;
                            trackwip2(6,10)=0;
                            asswip2(6,11)=0;
                            trackwip2(6,11)=0;
                            asswip2(6,12)=0;
                            trackwip2(6,12)=0;
                            asswip2(6,13)=0;
                            trackwip2(6,13)=0;
                        end
                    end
                    if percw3==0
                        if b4~=0 && (assegnatoconprio(i,j)==31 || assegnatoconprio(i,j)==21 || assegnatoconprio(i,j)==29 && ismember(assegnatoconprio(i,j),daassegnare(i,b1+b2+b3+1:b1+b2+b3+b4))) 
                            asswip3(2,6)=0;
                            trackwip3(2,6)=0;
                            asswip3(4,7)=0;
                            trackwip3(4,7)=0;
                            asswip3(7,10)=0;
                            trackwip3(7,10)=0;
                            asswip3(7,11)=0;
                            trackwip3(7,11)=0;
                            asswip3(7,12)=0;
                            trackwip3(7,12)=0;
                            asswip3(7,12)=0;
                            trackwip3(7,13)=0;
                        end
                        if b4~=0 && (assegnatoconprio(i,j)==30 || assegnatoconprio(i,j)==20 || assegnatoconprio(i,j)==28) && ismember(assegnatoconprio(i,j),daassegnare(i,b1+b2+b3+1:b1+b2+b3+b4))
                            asswip3(1,6)=0;
                            trackwip3(1,6)=0;
                            asswip3(3,7)=0;
                            trackwip3(3,7)=0;
                            asswip3(6,10)=0;
                            trackwip3(6,10)=0;
                            asswip3(6,11)=0;
                            trackwip3(6,11)=0;
                            asswip3(6,12)=0;
                            trackwip3(6,12)=0;
                            asswip3(6,13)=0;
                            trackwip3(6,13)=0;
                        end
                    end
                    if percw4==0
                        if b5~=0 && (assegnatoconprio(i,j)==31 || assegnatoconprio(i,j)==21 || assegnatoconprio(i,j)==29) && ismember(assegnatoconprio(i,j),daassegnare(i,b1+b2+b3+b4+1:b1+b2+b3+b4+b5))
                            asswip4(2,6)=0;
                            trackwip4(2,6)=0;
                            asswip4(4,7)=0;
                            trackwip4(4,7)=0;
                            asswip4(7,10)=0;
                            trackwip4(7,10)=0;
                            asswip4(7,11)=0;
                            trackwip4(7,11)=0;
                            asswip4(7,12)=0;
                            trackwip4(7,12)=0;
                            asswip4(7,12)=0;
                            trackwip4(7,13)=0;
                        end
                        if b5~=0 && (assegnatoconprio(i,j)==30 || assegnatoconprio(i,j)==20 || assegnatoconprio(i,j)==28) && ismember(assegnatoconprio(i,j),daassegnare(i,b1+b2+b3+b4+1:b1+b2+b3+b4+b5))
                            asswip4(1,6)=0;
                            trackwip4(1,6)=0;
                            asswip4(3,7)=0;
                            trackwip4(3,7)=0;
                            asswip4(6,10)=0;
                            trackwip4(6,10)=0;
                            asswip4(6,11)=0;
                            trackwip4(6,11)=0;
                            asswip4(6,12)=0;
                            trackwip4(6,12)=0;
                            asswip4(6,13)=0;
                            trackwip4(6,13)=0;
                        end
                    end
                end
        end
        KK(i)=nnz(assegnatotask(i,:));
        if assegnatotask(i,10)~=0
            KK(i)=KK(i)-1;
        end
        if KK(i)~=0
            nopdisp(i)=9-nnz(W(i,1:9)); %conto quanti operatori generici sono liberi (quindi possono essere assegnati)
            [~,v,~]=find(~W(i,1:9));
            vi(i,1:nopdisp(i))=v;
            if assegnatotask(i,10)~=0
                vi(i,nopdisp(i)+1)=10;
            end
            NPK=npermutek(v,KK(i));
            r=size(NPK,1); %numero di righe di NPK
            if r==1
                NPK=transpose(NPK);
                r=size(NPK,1);
            end
            c=size(NPK,2); %numero di colonne di NPK
            if find(assegnprioritaria(i,:)==10)
                col=10*ones(r,1);
                c=c+1;
            end
            z=1;
            [~,jnd,~]=find(assegnprioritaria(i,:));
            for j=1:nnz(assegnprioritaria(i,:)) %potrei dire anche che va fino a numel(jnd)
                if j==1
                    if assegnprioritaria(i,jnd(j))==10
                        NPKn=col;
                    else
                        NPKn=NPK(:,j);
                        z=z+1;
                    end
                else
                    if assegnprioritaria(i,jnd(j))==10
                        NPKn=[NPKn,col];
                    else
                        NPKn=[NPKn,NPK(:,z)];
                        z=z+1;
                    end
                end
            end
            A{i}=NPKn;
            NPKn=[NPKn,zeros(r,8-c)];
            [~,I]=ismember(NPKn,azioni,'rows');
            [I,~,~] = find(I);
            NPKn(I,:)=[];
            r=r-numel(I);
            azioni(in:in+r-1,:)=NPKn;
            in=in+r;
        else
            if W(i,10)==0
                A{i}=10;
                vi(i,:)=[10,0,0,0,0,0,0,0,0,0];
                if ismember([10,0,0,0,0,0,0,0],azioni,'rows')==0
                    azioni(in,:)=[10,0,0,0,0,0,0,0];
                    in=in+1;
                end
            end
        end
        assegnati=nnz(assegnato(i,:));
        %segno le prob che gli op non siano disp e se ci sono faccio i casi a parte
        %una volta esplorato tutto posso passare allo stato successivo (quello che suppone l'evoluzione naturale)
        W(i+1,:)=W(i,:)+assegnato(i,:);
        Wt(i+1,:)=Wt(i,:)+assegnatotask(i,:);
        Wp(i+1,:)=Wp(i,:);
        S(i+1,1:33)=S(i,1:33);
        S(i+1,42)=S(i,42);
        s(i+1,:)=s(i,:);
        St(i+1,:)=St(i,:);
        I=find(assegnato(i,:));
        for j=1:nnz(assegnato(i,:))
            S(i+1,assegnatotask(i,I(j)))=assegnatoop(i,I(j));
            if 1<=assegnatotask(i,I(j)) && assegnatotask(i,I(j))<=15
                if assegnatotask(i,I(j))==12
                    w12=0;
                    if perc==2
                        perc=0;
                    elseif percw==2
                        percw=0;
                    elseif percw2==2
                        percw2=0;
                    elseif percw3==2
                        percw3=0;
                    elseif percw4==2
                        percw4=0;    
                    end
                end
                if assegnatotask(i,I(j))==13
                    w11=0;
                    if perc==1
                        perc=0;
                    elseif percw==1
                        percw=0;
                    elseif percw2==1
                        percw2=0;
                    elseif percw3==1
                        percw3=0;
                    elseif percw4==1
                        percw4=0;    
                    end
                end
                St(i+1,task(assegnatotask(i,I(j)),9))=1;
            elseif assegnatotask(i,I(j))~=17 
                St(i+1,task(assegnatotask(i,I(j)),9))=0;
                if assegnatotask(i,I(j))==25 || assegnatotask(i,I(j))==27
                    zeta=find(daassegnare(i,:)==assegnatotask(i,I(j)));
                    pass=assegnatotask(i,I(j));
                end
                if zeta>0
                    if zeta<=b1
                        Stt(i+1,6)=1;
                    elseif zeta>b1 && zeta<=b1+b2
                        Stt(i+1,6)=2;
                    elseif zeta>b1+b2 && zeta<=b1+b2+b3
                        Stt(i+1,6)=3;
                    elseif zeta>b1+b2+b3 && zeta<=b1+b2+b3+b4
                        Stt(i+1,6)=4;
                    elseif zeta>b1+b2+b3+b4 && zeta<=b1+b2+b3+b4+b5
                        Stt(i+1,6)=5;
                    end
                end
            end
            if assegnatotask(i,I(j))==31 || assegnatotask(i,I(j))==21 || assegnatotask(i,I(j))==29
                w11=1;
                if b1~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,1:b1))
                    perc=1;
                elseif b2~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1:b2))
                    percw=1;
                elseif b3~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1+b2:b3))
                    percw2=1;
                elseif b4~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1+b2+b3:b4))
                    percw3=1;
                elseif b5~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1+b2+b3+b4:b5))
                    percw4=1;
                end
            end
            if assegnatotask(i,I(j))==30 || assegnatotask(i,I(j))==20 || assegnatotask(i,I(j))==28
                w12=1;
                if b1~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,1:b1))
                    perc=2;
                elseif b2~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1:b2))
                    percw=2;
                elseif b3~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1+b2:b3))
                    percw2=2;
                elseif b4~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1+b2+b3:b4))
                    percw3=2;
                elseif b5~=0 && ismember(assegnatotask(i,I(j)),daassegnare(i,b1+1+b2+b3+b4:b5))
                    percw4=2;
                end
            end
            [g,h]=find(P(:,1:13)==assegnatotask(i,I(j)));
            if s(i,assegnatotask(i,I(j)))==1
                trackassegnamento(g,h)=0;
            elseif s(i,assegnatotask(i,I(j)))==2
                asswip(g,h)=0;
            elseif s(i,assegnatotask(i,I(j)))==3
                asswip2(g,h)=0;
            elseif s(i,assegnatotask(i,I(j)))==4
                asswip3(g,h)=0;
            elseif s(i,assegnatotask(i,I(j)))==5
                asswip4(g,h)=0;    
            end
        end
        for j=1:nnz(assegnatoconprio(i,:))
                if rngen(1,assegnatoconprio(i,j))==1
                    rng('default');
                    rngen(1,assegnatoconprio(i,j))=0;
                end
                rand(i,j)=round(random(pd{assegnatoconprio(i,j)},1),1);
                tempi(i,assegnatoconprio(i,j))=rand(i,j);
        end
    else
        W(i+1,:)=W(i,:);
        Wt(i+1,:)=Wt(i,:);
        Wp(i+1,:)=Wp(i,:);
        S(i+1,1:33)=S(i,1:33);
        S(i+1,42)=S(i,42);
        s(i+1,:)=s(i,:);
        St(i+1,:)=St(i,:);
    end
    if i==1
        vi_univ(n_vi_univ+1,:)=vi(i,:);
        n_vi_univ=n_vi_univ+1;
    elseif ~ismember(vi(i,:),vi_univ(1:n_vi_univ-1,:),'rows')
                vi_univ(n_vi_univ+1,:)=vi(i,:);
                n_vi_univ=n_vi_univ+1;
    end
    [~,ind,randoms]=find(tempi(i,:));
    randorder=floor(tiedrank(randoms));
    J=find(randorder==1);
    ttemp(i)=tempi(i,ind(J(1)));
    for j=1:nnz(rand(i,:))
            tempi(i+1,assegnatoconprio(i,j))=rand(i,j)-ttemp(i);
    end
    for j=1:numel(J)
        finisce(i,j)=ind(J(j));
        [g,h]=find(P(:,1:13)==ind(J(j)));
        if s(i,ind(J(j)))==1
            trackcompletamento(g,h)=0;
        elseif s(i,ind(J(j)))==2
            trackwip(g,h)=0;
            s(i+1,ind(J(j)))=1;
        elseif s(i,ind(J(j)))==3
            trackwip2(g,h)=0;
            s(i+1,ind(J(j)))=1;
        elseif s(i,ind(J(j)))==4
            trackwip3(g,h)=0;
            s(i+1,ind(J(j)))=1;
        elseif s(i,ind(J(j)))==5
            trackwip4(g,h)=0;
            s(i+1,ind(J(j)))=1;    
        end
        S(i+1,P(g,h))=0;
        [~,f]=find(Wt(i+1,:)==ind(J(j)));
        for z=1:numel(f)
            if Wt(i+1,f(z))>=16 && Wt(i+1,f(z))<=33
                Wp(i+1,f(z))=task(Wt(i+1,f(z)),10);
            end
            W(i+1,f(z))=0;
            Wt(i+1,f(z))=0;
        end
        [n,m]=find(daassegnare==ind(J(j)));
        [n,o]=max(n);
        m=m(o);
        if s(i,ind(J(j)))==1
            trackcompletamento(g,14)=trackcompletamento(g,14)-rand(n,m);
            if trackcompletamento(g,14)<0
                trackcompletamento(g,14)=abs(trackcompletamento(g,14));
            end
        elseif s(i,ind(J(j)))==2
            trackwip(g,14)=trackwip(g,14)-rand(n,m);
            if trackwip(g,14)<0
                trackwip(g,14)=abs(trackwip(g,14));
            end
        elseif s(i,ind(J(j)))==3
            trackwip2(g,14)=trackwip2(g,14)-rand(n,m);
            if trackwip2(g,14)<0
                trackwip2(g,14)=abs(trackwip2(g,14));
            end
        elseif s(i,ind(J(j)))==4
            trackwip3(g,14)=trackwip3(g,14)-rand(n,m);
            if trackwip3(g,14)<0
                trackwip3(g,14)=abs(trackwip3(g,14));
            end
        elseif s(i,ind(J(j)))==5
            trackwip4(g,14)=trackwip4(g,14)-rand(n,m);
            if trackwip4(g,14)<0
                trackwip4(g,14)=abs(trackwip4(g,14));
            end    
        end
    end
    if Stt(i,6)~=0 && pass~=0
        if ismember (pass,finisce(i,:))
            pass=0;
            zeta=0;
        else
            Stt(i+1,6)=Stt(i,6);
            zeta=0;
        end
    end
    for j=1:7
      if trackcompletamento(j,k)==0
          avanza1=avanza1+1;
      end
      if trackwip(j,q)==0
          avanza2=avanza2+1;
      end
      if trackwip2(j,qq)==0
          avanza3=avanza3+1;
      end
      if trackwip3(j,q3)==0
          avanza4=avanza4+1;
      end
      if trackwip4(j,q4)==0
          avanza5=avanza5+1;
      end
    end
    if avanza1==7
        k=k+1;
    end
    if avanza2==7
        q=q+1;
    end
    if avanza3==7
        qq=qq+1;
    end
    if avanza4==7
        q3=q3+1;
    end
    if avanza5==7
        q4=q4+1;
    end
    avanza1=0;
    avanza2=0;
    avanza3=0;
    avanza4=0;
    avanza5=0;
    i=i+1;
    t(i)=t(i-1)+ttemp(i-1);
    tempi(i,ind)=tempi(i-1,ind)-ttemp(i-1);
    if trackcompletamento(1:7,13)==0
        produzione=produzione+1;
        out(produzione)=t(i);
        S(i,42)=produzione;
        for j=1:7
            trackcompletamento(j,:)=trackwip(j,:);
            trackassegnamento(j,:)=asswip(j,:);
            trackwip(j,:)=trackwip2(j,:);
            asswip(j,:)=asswip2(j,:);
            trackwip2(j,:)=trackwip3(j,:);
            asswip2(j,:)=asswip3(j,:);
            trackwip3(j,:)=trackwip4(j,:);
            asswip3(j,:)=asswip4(j,:);
        end
        trackwip4=[1 1 1 1 1 1 0 0 0 0 0 0 0 552; 0 0 0 0 0 1 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 0 0 0 0 0 0 1386; 0 0 0 0 0 0 1 0 0 0 0 0 0 25; 0 0 1 0 0 0 0 0 0 0 0 0 0 15; 1 1 1 1 1 1 1 1 1 1 1 1 1 4889; 0 0 0 0 0 0 0 0 0 1 1 1 1 2434];
        asswip4=[1 1 1 1 1 1 0 0 0 0 0 0 0; 0 0 0 0 0 1 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 0 0 0 0 0 0; 0 0 0 0 0 0 1 0 0 0 0 0 0; 0 0 1 0 0 0 0 0 0 0 0 0 0; 1 1 1 1 1 1 1 1 1 1 1 1 1; 0 0 0 0 0 0 0 0 0 1 1 1 1];
        k=q;
        q=qq;
        qq=q3;
        q3=q4;
        q4=1;
        for j=1:33
            if s(i,j)~=1
                if s(i,j)==2
                    s(i,j)=1;
                elseif s(i,j)==3
                    s(i,j)=2;
                elseif s(i,j)==4
                    s(i,j)=3;
                elseif s(i,j)==5
                    s(i,j)=4;    
                end
            end
        end
        if percw==1
            perc=1;
            percw=0;
        end
        if percw==2
            perc=2;
            percw=0;
        end
        if percw2==1
            percw=1;
            percw2=0;
        end
        if percw2==2
            percw=2;
            percw2=0;
        end
        if percw3==1
            percw2=1;
            percw3=0;
        end
        if percw3==2
            percw2=2;
            percw3=0;
        end
        if percw4==1
            percw3=1;
            percw4=0;
        end
        if percw4==2
            percw3=2;
            percw4=0;
        end
    end
    if produzione==145
        END=1;
    end
    if END==1
        S(i,43)=1;
        xx=unique(S,'rows');
    end
end